// config: norepeat

#include "GetObjects.js"

function DoMove()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowEditPoints();
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	moi.ui.hideUI( 'done' );
	moi.ui.showUI( 'BasePointPrompt' );
	moi.ui.showUI( 'BaseOptions' );
	moi.ui.endUIUpdate();
	
	var basept;

	var pointpicker = moi.ui.createPointPicker();
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
		{
			basept = pointpicker.pt;
			break;
		}
			
		if ( pointpicker.event == 'BoundingBoxCenter' )
		{
			basept = objects.getHighAccuracyBoundingBox().center;
			moi.ui.addPickedPoint( basept );
			break;
		}		
	}
		
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'BasePointPrompt' );
	moi.ui.hideUI( 'BaseOptions' );
	moi.ui.showUI( 'TargetPointPrompt' );
	moi.ui.showUI( 'TargetOptions1' );
	moi.ui.endUIUpdate();

	var movefactory = moi.command.createFactory( 'move' );
	
	movefactory.setInput( 0, objects );
	movefactory.setInput( 1, basept );

	pointpicker.bindResultPt( movefactory.getInput(2) );
	pointpicker.restrictToPlaneThroughPt( basept, false );
	pointpicker.stickToSurfacesMode = 'none';
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return false;
			
		if ( pointpicker.event == 'finished' )
			break;
			
		if ( pointpicker.event == 'DistanceFromEdgeBtn' )
		{
			// Clicked the Distance from edge button - enable the distance control.
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'TargetOptions1' );
			moi.ui.showUI( 'TargetOptions2' );
			moi.ui.endUIUpdate();
			
			moi.ui.bindUIToInput( 'Distance', 'value', movefactory.getInput(4) );
			pointpicker.bindResultCPlane( movefactory.getInput(5) );
			pointpicker.stickToSurfacesMode = 'min';
		}
	}
		
	movefactory.commit();
}

DoMove();
